# AppKit: Implementing Liquid Glass Design

> WWDC25 | macOS Tahoe 26  
> 🎬 https://developer.apple.com/videos/play/wwdc2025/310/  
> 🎬 https://developer.apple.com/videos/play/wwdc2025/269/

---

## 개요

macOS Tahoe는 **Liquid Glass** 머티리얼을 도입하여 Mac 앱의 외관을 새롭게 합니다. AppKit은 이 새로운 디자인을 자동으로 적용하면서도, 커스터마이징할 수 있는 API를 제공합니다.

---

## 자동 적용되는 변경 사항

### 윈도우 구조

- 윈도우 모양이 변경되고 주요 구조 영역이 Glass로 감싸짐
- **툴바**가 Glass 머티리얼 위에 배치되어 콘텐츠 위에 떠 있는 효과
- 컨트롤이 논리적 그룹으로 자동 묶임
- 스크롤 시 Glass가 배경 밝기에 따라 라이트/다크 자동 전환

### 컨트롤 그룹핑

```swift
// 자동으로 같은 Glass 위에 그룹핑됨
toolbar.items = [button1, button2, button3]

// NSToolbarItemGroup으로 명시적 그룹핑
let group = NSToolbarItemGroup(itemIdentifiers: [.item1, .item2])

// 스페이서로 분리
toolbar.insertItem(withItemIdentifier: .space, at: 2)
```

### 비대화형 항목에서 Glass 제거

정보성 텍스트나 상태 표시 등 비대화형 항목은 Glass가 적용되지 않아야 합니다.

---

## Scroll Edge Effect

콘텐츠와 Glass 요소 사이의 시각적 분리를 제공합니다.

```swift
// NSScrollView에서 자동으로 적용됨
// 두 가지 변형:
// - Soft-edge: 점진적 페이드와 블러
// - Hard-edge: 불투명한 배경으로 더 강한 분리
```

- 툴바 아이템 아래에 자동 적용
- 타이틀바 액세서리 아래에 적용
- **Split Item Accessories** (신규): 스플릿 뷰 내 개별 패널에 적용

---

## 커스텀 Glass 효과

### NSGlassEffect API

```objc
// Objective-C
NSView *customView = [[NSView alloc] init];
NSGlassEffect *glass = [NSGlassEffect regularGlass];
customView.glassEffect = glass;

// 틴트 적용
glass = [glass glassByApplyingTint:[NSColor systemBlueColor]];
customView.glassEffect = glass;
```

### 인터랙티브 Glass

```objc
// 인터랙티브 요소에는 interactive Glass 사용
NSGlassEffect *interactiveGlass = [[NSGlassEffect regularGlass] interactiveGlass];
button.glassEffect = interactiveGlass;
```

---

## NSSplitViewController 업데이트

- Inspector 지원 및 리사이즈 가능한 컬럼
- Split Item Accessories가 개별 스플릿에 적용
- 시스템 구현 사용 권장 (스크롤 엣지 이펙트, 레이어링, 풀스크린 등 자동 처리)

---

## 디자인 옵트아웃

```xml
<!-- Info.plist에서 임시로 새 디자인 비활성화 -->
<key>UIDesignRequiresLiquidGlass</key>
<false/>
```

> ⚠️ 이 키는 임시용이며 다음 메이저 릴리스에서 제거될 예정입니다.

---

## 모범 사례

1. **표준 시스템 컨트롤 사용**: 자동으로 Glass 디자인 적용
2. **Glass on Glass 피하기**: 겹치는 툴바와 스크롤 콘텐츠 주의
3. **색상은 의미를 전달**: 브랜딩이 아닌 상태/액션 표현에 사용
4. **브랜드 색상은 Glass 뒤 콘텐츠에 적용**: Glass 자체를 틴팅하지 않기
5. **Dark Mode 지원 확인**: Glass가 자동으로 외관 변경을 전파

---

## 관련 세션

- [Build an AppKit app with the new design (310)](https://developer.apple.com/videos/play/wwdc2025/310/)
- [Meet Liquid Glass (269)](https://developer.apple.com/videos/play/wwdc2025/269/)
- [Get to know the new design system (252)](https://developer.apple.com/videos/play/wwdc2025/252/)
