# SwiftUI New Toolbar Features

> WWDC25 | iOS 26, macOS Tahoe  
> 🎬 https://developer.apple.com/videos/play/wwdc2025/256/

---

## 개요

iOS 26에서 SwiftUI 툴바가 Liquid Glass 디자인과 함께 대폭 개선되었습니다. 새로운 배치 옵션, Glass 그룹핑, 스페이서 API 등이 추가되었습니다.

---

## Toolbar Glass 그룹핑

### 자동 그룹핑

같은 placement에 있는 아이템들이 자동으로 하나의 Glass 캡슐에 묶입니다.

```swift
.toolbar {
    // 이 두 버튼은 하나의 Glass 그룹
    ToolbarItem(placement: .primaryAction) {
        Button("편집", systemImage: "pencil") { }
    }
    ToolbarItem(placement: .primaryAction) {
        Button("공유", systemImage: "square.and.arrow.up") { }
    }
}
```

### ToolbarItemGroup 명시적 그룹핑

```swift
.toolbar {
    ToolbarItemGroup(placement: .primaryAction) {
        Button("볼드", systemImage: "bold") { }
        Button("이탤릭", systemImage: "italic") { }
        Button("밑줄", systemImage: "underline") { }
    }
}
```

---

## 새로운 Toolbar Spacer API

### ToolbarSpacer

아이템 사이에 공간을 추가하여 별도의 Glass 그룹으로 분리합니다.

```swift
.toolbar {
    // 그룹 1: 네비게이션
    ToolbarItem(placement: .topBarLeading) {
        Button("뒤로", systemImage: "chevron.left") { }
    }
    
    // 스페이서로 분리
    ToolbarSpacer(.fixed)
    
    // 그룹 2: 액션
    ToolbarItemGroup(placement: .topBarTrailing) {
        Button("검색", systemImage: "magnifyingglass") { }
        Button("더보기", systemImage: "ellipsis") { }
    }
}
```

### Spacer 유형

```swift
// 고정 스페이서 - 일정한 간격
ToolbarSpacer(.fixed)

// 유연한 스페이서 - 남은 공간 채움
ToolbarSpacer(.flexible)
```

---

## Bottom Bar 업데이트

### 새로운 Bottom Bar Placement

```swift
.toolbar {
    // 하단 바에 아이템 배치
    ToolbarItem(placement: .bottomBar) {
        HStack {
            Button("이전", systemImage: "chevron.left") { }
            Spacer()
            Text("3 / 10")
            Spacer()
            Button("다음", systemImage: "chevron.right") { }
        }
    }
}
```

---

## Title Menu 업데이트

```swift
NavigationStack {
    ContentView()
        .navigationTitle("문서")
        .toolbarTitleMenu {
            // 타이틀 탭 시 나타나는 메뉴
            Button("이름 변경", systemImage: "pencil") { }
            Button("복제", systemImage: "doc.on.doc") { }
            Button("이동", systemImage: "folder") { }
            
            Divider()
            
            Button("삭제", systemImage: "trash", role: .destructive) { }
        }
}
```

---

## 툴바 가시성 제어

```swift
NavigationStack {
    ScrollView {
        // 콘텐츠
    }
    .toolbar {
        ToolbarItem(placement: .primaryAction) {
            Button("액션") { }
        }
    }
    // 스크롤 시 툴바 자동 숨김/표시
    .toolbarVisibility(.automatic, for: .navigationBar)
    
    // 항상 표시
    .toolbarVisibility(.visible, for: .bottomBar)
    
    // 숨김
    .toolbarVisibility(.hidden, for: .tabBar)
}
```

---

## 툴바 배경 커스터마이징

```swift
.toolbar {
    ToolbarItem(placement: .primaryAction) {
        Button("저장") { }
    }
}
// Glass 배경 색상 커스터마이징
.toolbarBackground(.blue.opacity(0.1), for: .navigationBar)

// 콘텐츠와 겹칠 때 배경 표시
.toolbarBackgroundVisibility(.automatic, for: .navigationBar)
```

---

## 인라인 타이틀과 툴바

```swift
NavigationStack {
    ContentView()
        .navigationTitle("편집기")
        .navigationBarTitleDisplayMode(.inline)
        .toolbar {
            // 인라인 타이틀과 같은 줄에 배치
            ToolbarItem(placement: .principal) {
                // 커스텀 타이틀 영역
                Picker("모드", selection: $mode) {
                    Text("편집").tag(Mode.edit)
                    Text("미리보기").tag(Mode.preview)
                }
                .pickerStyle(.segmented)
                .frame(width: 200)
            }
        }
}
```

---

## 관련 세션

- [What's new in SwiftUI (256)](https://developer.apple.com/videos/play/wwdc2025/256/)
